IF EXISTS
(
    SELECT *
    FROM sys.views
    WHERE object_id = OBJECT_ID(N'[dbo].V_PRC_FILIAL_SRV_TELE_TENTACLE')
)
    DROP VIEW [dbo].[V_PRC_FILIAL_SRV_TELE_TENTACLE];
GO

CREATE VIEW [dbo].[V_PRC_FILIAL_SRV_TELE_TENTACLE]  
AS  
SELECT
  PRC_FILIAL_SRV_TELE.CD_EMP,
  PRC_FILIAL_SRV_TELE.CD_FILIAL,
  PRC_FILIAL_SRV_TELE.CD_SRV,
  PRC_FILIAL_SRV_TELE.SRV,
  0 AS OFFLINE,
  CONVERT(INT,ISNULL(CONFIG.TP_CONEXAO,0)) AS TP_CONEXAO
FROM PRC_FILIAL_SRV_TELE LEFT JOIN 
    (SELECT CD_EMP,CD_FILIAL,ISNULL(VALOR,0) AS TP_CONEXAO 
	   FROM PRC_FILIAL_CONFIG 
	   WHERE PRC_FILIAL_CONFIG.CD_CHAVE = 'FLAG_PRC_FILIAL_SRV_TELE') AS CONFIG ON
    CONFIG.CD_EMP=PRC_FILIAL_SRV_TELE.CD_EMP AND
    CONFIG.CD_FILIAL=PRC_FILIAL_SRV_TELE.CD_FILIAL
	WHERE PRC_FILIAL_SRV_TELE.CD_EMP = 1
GO